/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.engine;

import com.google.common.collect.Maps;
import com.suncode.autoupdate.plusworkflow.config.Config;
import com.suncode.autoupdate.plusworkflow.config.CorruptedConfigException;
import com.suncode.autoupdate.plusworkflow.update.State;
import com.suncode.autoupdate.plusworkflow.update.Updates;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdater;
import com.suncode.autoupdate.plusworkflow.util.Consumer;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateEngine {
    private static final Logger log = LoggerFactory.getLogger(UpdateEngine.class);
    @Autowired
    private PluginStore store;
    @Autowired
    private List<ComponentUpdater> updaters;
    volatile Config config;
    volatile UpdateServerClient client;

    public boolean isConfigured() {
        return this.client != null;
    }

    @PostConstruct
    public void restore() {
        block16: {
            PluginStoreResource resource = this.store.read("config.json");
            if (resource == null) break block16;
            try (InputStream inputStream = resource.getInputStream();){
                try {
                    this.applyConfiguration(Config.read(inputStream));
                }
                catch (CorruptedConfigException e) {
                    log.info("Cannot restore saved config file: config will be reset", (Throwable)e);
                }
            }
        }
    }

    public void applyConfiguration(Config config) {
        config.save(new Consumer<InputStream>(){

            @Override
            public void accept(InputStream inputStream) {
                UpdateEngine.this.store.store("config.json", inputStream, true);
            }
        });
        this.config = config;
        this.client = UpdateServerClient.builder().apiToken(config.getApiToken()).environment(config.getEnvironment()).updateServerAddress(config.getServerUrl()).build();
    }

    public State getState() {
        return State.builder().config(this.config).configured(this.client != null).updates(this.getUpdates()).build();
    }

    public ComponentUpdate update(String project) {
        for (ComponentUpdater updater : this.updaters) {
            for (ComponentUpdate component : updater.getComponents()) {
                if (!component.key().equals(project)) continue;
                return component;
            }
        }
        throw new IllegalArgumentException("No update for poject " + project);
    }

    private Map<String, Updates> getUpdates() {
        HashMap merged = Maps.newHashMap();
        for (ComponentUpdater updater : this.updaters) {
            for (ComponentUpdate component : updater.getComponents()) {
                Updates updates = component.getUpdates();
                if (updates == null) continue;
                merged.put(component.key(), updates);
            }
        }
        return merged;
    }

    public Config getConfig() {
        return this.config;
    }

    public UpdateServerClient getClient() {
        return this.client;
    }
}

