/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.download;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.autoupdate.server.client.api.Patches;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class Downloader {
    private static final Logger log = LoggerFactory.getLogger(Downloader.class);
    @Autowired
    private PluginStore store;

    public void upload(PatchMeta patch, InputStream stream) {
        String path = this.patchPath(patch);
        this.store.store(path, stream, true);
        log.info("Patch {} has been uploaded", (Object)patch);
    }

    @Async
    public Future<PluginStoreResource> download(Patch patch, UpdateServerClient client) {
        String path = this.patchPath(patch);
        PluginStoreResource downloaded = this.store.read(path);
        if (downloaded == null) {
            log.info("Downloading patch {} from server and storing in {}", (Object)patch, (Object)path);
            this.downloadFromServer(client, path, patch);
            downloaded = this.store.read(path);
        }
        log.info("Patch {} has been downloaded", (Object)patch);
        return new AsyncResult((Object)downloaded);
    }

    private void downloadFromServer(UpdateServerClient client, final String path, final Patch patch) {
        try {
            client.patches().download(patch, new Patches.PatchStreamConsumer(){

                public void accept(InputStream inputStream) throws IOException {
                    log.info("Storing patch {} in plugin store under {}", (Object)patch, (Object)path);
                    Downloader.this.store.store(path, inputStream);
                    log.info("Patch {} stored under {}", (Object)patch, (Object)path);
                }
            });
        }
        catch (IOException e) {
            this.store.delete(path);
            throw e;
        }
    }

    private String patchPath(Patch patch) {
        return "downloads/" + patch.getId();
    }

    private String patchPath(PatchMeta patch) {
        return "downloads/" + patch.getPatchId();
    }
}

