/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update.download;

import com.google.common.base.Preconditions;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.plugin.framework.PluginStoreResource;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.NonNull;

public final class Download {
    @NonNull
    private final Map<Patch, Future<PluginStoreResource>> tasks;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void await() {
        for (Future<PluginStoreResource> futures : this.tasks.values()) {
            try {
                futures.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
                return;
            }
        }
    }

    public PluginStoreResource patchArchive(Patch patch) {
        Future<PluginStoreResource> future = this.tasks.get(patch);
        Preconditions.checkState((boolean)future.isDone());
        return future.get();
    }

    @ConstructorProperties(value={"tasks"})
    Download(@NonNull Map<Patch, Future<PluginStoreResource>> tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.tasks = tasks;
    }

    public static DownloadBuilder builder() {
        return new DownloadBuilder();
    }

    @NonNull
    public Map<Patch, Future<PluginStoreResource>> getTasks() {
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Download)) {
            return false;
        }
        Download other = (Download)o;
        Map<Patch, Future<PluginStoreResource>> this$tasks = this.getTasks();
        Map<Patch, Future<PluginStoreResource>> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Patch, Future<PluginStoreResource>> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "Download(tasks=" + this.getTasks() + ")";
    }

    public static class DownloadBuilder {
        private ArrayList<Patch> tasks$key;
        private ArrayList<Future<PluginStoreResource>> tasks$value;

        DownloadBuilder() {
        }

        public DownloadBuilder task(Patch taskKey, Future<PluginStoreResource> taskValue) {
            if (this.tasks$key == null) {
                this.tasks$key = new ArrayList();
                this.tasks$value = new ArrayList();
            }
            this.tasks$key.add(taskKey);
            this.tasks$value.add(taskValue);
            return this;
        }

        public DownloadBuilder tasks(Map<? extends Patch, ? extends Future<PluginStoreResource>> tasks) {
            if (tasks == null) {
                throw new NullPointerException("tasks cannot be null");
            }
            if (this.tasks$key == null) {
                this.tasks$key = new ArrayList();
                this.tasks$value = new ArrayList();
            }
            for (Map.Entry<? extends Patch, ? extends Future<PluginStoreResource>> $lombokEntry : tasks.entrySet()) {
                this.tasks$key.add($lombokEntry.getKey());
                this.tasks$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public DownloadBuilder clearTasks() {
            if (this.tasks$key != null) {
                this.tasks$key.clear();
                this.tasks$value.clear();
            }
            return this;
        }

        public Download build() {
            Map<Patch, Future<PluginStoreResource>> tasks;
            switch (this.tasks$key == null ? 0 : this.tasks$key.size()) {
                case 0: {
                    tasks = Collections.emptyMap();
                    break;
                }
                case 1: {
                    tasks = Collections.singletonMap(this.tasks$key.get(0), this.tasks$value.get(0));
                    break;
                }
                default: {
                    tasks = new LinkedHashMap<Patch, Future<PluginStoreResource>>(this.tasks$key.size() < 0x40000000 ? 1 + this.tasks$key.size() + (this.tasks$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.tasks$key.size(); ++$i) {
                        tasks.put(this.tasks$key.get($i), this.tasks$value.get($i));
                    }
                    tasks = Collections.unmodifiableMap(tasks);
                }
            }
            return new Download(tasks);
        }

        public String toString() {
            return "Download.DownloadBuilder(tasks$key=" + this.tasks$key + ", tasks$value=" + this.tasks$value + ")";
        }
    }
}

