/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update;

import com.google.common.collect.ImmutableMap;
import com.suncode.autoupdate.server.client.api.Patch;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class PendingPatch {
    @NonNull
    private final UUID id;
    @NonNull
    private final String fromVersion;
    @NonNull
    private final String toVersion;
    @NonNull
    private final Map<String, String> properties;

    public static PendingPatch from(Patch patch) {
        return new PendingPatch(patch.getId(), patch.getFromVersion(), patch.getToVersion(), (Map<String, String>)ImmutableMap.copyOf((Map)patch.getProperties()));
    }

    public static List<PendingPatch> map(List<Patch> patches) {
        return patches.stream().map(PendingPatch::from).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"id", "fromVersion", "toVersion", "properties"})
    public PendingPatch(@NonNull UUID id, @NonNull String fromVersion, @NonNull String toVersion, @NonNull Map<String, String> properties) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (fromVersion == null) {
            throw new NullPointerException("fromVersion is marked non-null but is null");
        }
        if (toVersion == null) {
            throw new NullPointerException("toVersion is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.id = id;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.properties = properties;
    }

    @NonNull
    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String getFromVersion() {
        return this.fromVersion;
    }

    @NonNull
    public String getToVersion() {
        return this.toVersion;
    }

    @NonNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingPatch)) {
            return false;
        }
        PendingPatch other = (PendingPatch)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$fromVersion = this.getFromVersion();
        String other$fromVersion = other.getFromVersion();
        if (this$fromVersion == null ? other$fromVersion != null : !this$fromVersion.equals(other$fromVersion)) {
            return false;
        }
        String this$toVersion = this.getToVersion();
        String other$toVersion = other.getToVersion();
        if (this$toVersion == null ? other$toVersion != null : !this$toVersion.equals(other$toVersion)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $fromVersion = this.getFromVersion();
        result = result * 59 + ($fromVersion == null ? 43 : $fromVersion.hashCode());
        String $toVersion = this.getToVersion();
        result = result * 59 + ($toVersion == null ? 43 : $toVersion.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PendingPatch(id=" + this.getId() + ", fromVersion=" + this.getFromVersion() + ", toVersion=" + this.getToVersion() + ", properties=" + this.getProperties() + ")";
    }
}

