/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.update;

import com.google.common.collect.Sets;
import com.suncode.autoupdate.plusworkflow.util.Predicates;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Changelog {
    private final Set<String> added;
    private final Set<String> updated;
    private final Set<String> deleted;

    public static Changelog none() {
        return Changelog.builder().build();
    }

    public boolean isDeleted(String path) {
        return this.deleted.contains(path);
    }

    public boolean isAdded(String path) {
        return this.added.contains(path);
    }

    public Changelog merge(Changelog next) {
        Set added = Stream.of(this.added, next.getAdded()).flatMap(Collection::stream).filter(Predicates.not(next::isDeleted)).filter(Predicates.not(this::isDeleted)).collect(Collectors.toSet());
        Set maybeUpdated = this.deleted.stream().filter(next::isAdded).collect(Collectors.toSet());
        Set updated = Stream.of(this.updated, next.getUpdated()).flatMap(Collection::stream).filter(Predicates.not(this::isAdded)).filter(Predicates.not(next::isDeleted)).collect(Collectors.toSet());
        Set deleted = Stream.of(this.deleted, next.getDeleted()).flatMap(Collection::stream).filter(Predicates.not(next::isAdded)).filter(Predicates.not(this::isAdded)).collect(Collectors.toSet());
        return Changelog.builder().added(added).updated((Collection<? extends String>)Sets.union(updated, maybeUpdated)).deleted(deleted).build();
    }

    @ConstructorProperties(value={"added", "updated", "deleted"})
    Changelog(Set<String> added, Set<String> updated, Set<String> deleted) {
        this.added = added;
        this.updated = updated;
        this.deleted = deleted;
    }

    public static ChangelogBuilder builder() {
        return new ChangelogBuilder();
    }

    public Set<String> getAdded() {
        return this.added;
    }

    public Set<String> getUpdated() {
        return this.updated;
    }

    public Set<String> getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Changelog)) {
            return false;
        }
        Changelog other = (Changelog)o;
        Set<String> this$added = this.getAdded();
        Set<String> other$added = other.getAdded();
        if (this$added == null ? other$added != null : !((Object)this$added).equals(other$added)) {
            return false;
        }
        Set<String> this$updated = this.getUpdated();
        Set<String> other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Set<String> this$deleted = this.getDeleted();
        Set<String> other$deleted = other.getDeleted();
        return !(this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $added = this.getAdded();
        result = result * 59 + ($added == null ? 43 : ((Object)$added).hashCode());
        Set<String> $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Set<String> $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        return result;
    }

    public String toString() {
        return "Changelog(added=" + this.getAdded() + ", updated=" + this.getUpdated() + ", deleted=" + this.getDeleted() + ")";
    }

    public static class ChangelogBuilder {
        private ArrayList<String> added;
        private ArrayList<String> updated;
        private ArrayList<String> deleted;

        ChangelogBuilder() {
        }

        public ChangelogBuilder added(String added) {
            if (this.added == null) {
                this.added = new ArrayList();
            }
            this.added.add(added);
            return this;
        }

        public ChangelogBuilder added(Collection<? extends String> added) {
            if (added == null) {
                throw new NullPointerException("added cannot be null");
            }
            if (this.added == null) {
                this.added = new ArrayList();
            }
            this.added.addAll(added);
            return this;
        }

        public ChangelogBuilder clearAdded() {
            if (this.added != null) {
                this.added.clear();
            }
            return this;
        }

        public ChangelogBuilder updated(String updated) {
            if (this.updated == null) {
                this.updated = new ArrayList();
            }
            this.updated.add(updated);
            return this;
        }

        public ChangelogBuilder updated(Collection<? extends String> updated) {
            if (updated == null) {
                throw new NullPointerException("updated cannot be null");
            }
            if (this.updated == null) {
                this.updated = new ArrayList();
            }
            this.updated.addAll(updated);
            return this;
        }

        public ChangelogBuilder clearUpdated() {
            if (this.updated != null) {
                this.updated.clear();
            }
            return this;
        }

        public ChangelogBuilder deleted(String deleted) {
            if (this.deleted == null) {
                this.deleted = new ArrayList();
            }
            this.deleted.add(deleted);
            return this;
        }

        public ChangelogBuilder deleted(Collection<? extends String> deleted) {
            if (deleted == null) {
                throw new NullPointerException("deleted cannot be null");
            }
            if (this.deleted == null) {
                this.deleted = new ArrayList();
            }
            this.deleted.addAll(deleted);
            return this;
        }

        public ChangelogBuilder clearDeleted() {
            if (this.deleted != null) {
                this.deleted.clear();
            }
            return this;
        }

        public Changelog build() {
            Set<String> deleted;
            Set<Object> updated;
            Set<Object> added;
            switch (this.added == null ? 0 : this.added.size()) {
                case 0: {
                    added = Collections.emptySet();
                    break;
                }
                case 1: {
                    added = Collections.singleton(this.added.get(0));
                    break;
                }
                default: {
                    added = new LinkedHashSet(this.added.size() < 0x40000000 ? 1 + this.added.size() + (this.added.size() - 3) / 3 : Integer.MAX_VALUE);
                    added.addAll(this.added);
                    added = Collections.unmodifiableSet(added);
                }
            }
            switch (this.updated == null ? 0 : this.updated.size()) {
                case 0: {
                    updated = Collections.emptySet();
                    break;
                }
                case 1: {
                    updated = Collections.singleton(this.updated.get(0));
                    break;
                }
                default: {
                    updated = new LinkedHashSet(this.updated.size() < 0x40000000 ? 1 + this.updated.size() + (this.updated.size() - 3) / 3 : Integer.MAX_VALUE);
                    updated.addAll(this.updated);
                    updated = Collections.unmodifiableSet(updated);
                }
            }
            switch (this.deleted == null ? 0 : this.deleted.size()) {
                case 0: {
                    deleted = Collections.emptySet();
                    break;
                }
                case 1: {
                    deleted = Collections.singleton(this.deleted.get(0));
                    break;
                }
                default: {
                    deleted = new LinkedHashSet(this.deleted.size() < 0x40000000 ? 1 + this.deleted.size() + (this.deleted.size() - 3) / 3 : Integer.MAX_VALUE);
                    deleted.addAll(this.deleted);
                    deleted = Collections.unmodifiableSet(deleted);
                }
            }
            return new Changelog(added, updated, deleted);
        }

        public String toString() {
            return "Changelog.ChangelogBuilder(added=" + this.added + ", updated=" + this.updated + ", deleted=" + this.deleted + ")";
        }
    }
}

