/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.resources;

import com.suncode.autoupdate.plusworkflow.update.Changelog;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.plugin.framework.Plugin;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.glowroot.agent.api.Glowroot;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/updates"})
public class UpdateActionResource {
    @Autowired
    private UpdateEngine engine;
    @Autowired
    private Plugin plugin;

    @RequestMapping(value={"/{project}/apply"}, method={RequestMethod.POST})
    @ResponseBody
    public void applyPlugin(@PathVariable String project, @RequestParam String version) {
        Glowroot.setTransactionType((String)"Auto update - plugin");
        Glowroot.setTransactionName((String)String.format("Auto update plugin [%s]", project));
        ComponentUpdate update = this.engine.update(project);
        update.updateTo(version);
    }

    @RequestMapping(value={"/{project}/apply/confirm"}, method={RequestMethod.POST})
    @ResponseBody
    public void confirm(@PathVariable String project, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date when) {
        ComponentUpdate update = this.engine.update(project);
        update.confirm(when);
    }

    @RequestMapping(value={"/{project}/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public void cancel(@PathVariable String project) {
        ComponentUpdate update = this.engine.update(project);
        update.cancel();
    }

    @RequestMapping(value={"/{project}/check"}, method={RequestMethod.POST})
    @ResponseBody
    public void check(@PathVariable String project) {
        ComponentUpdate update = this.engine.update(project);
        update.check();
    }

    @RequestMapping(value={"/{project}/rollback"}, method={RequestMethod.POST})
    @ResponseBody
    public void rollback(@PathVariable String project, @RequestBody Rollback rollback) {
        ComponentUpdate update = this.engine.update(project);
        update.rollback(rollback);
    }

    @RequestMapping(value={"/{project}/changelog"}, method={RequestMethod.GET})
    @ResponseBody
    public Changelog getChangelog(@PathVariable String project) {
        return this.engine.update(project).getPendingChangelog();
    }

    @RequestMapping(value={"/{project}/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public Result upload(@PathVariable String project, @RequestParam(value="file") MultipartFile file) {
        return this.engine.update(project).apply(file.getInputStream()).fold(() -> new Result(true, ""), invalidVersion -> new Result(false, this.plugin.getMessage("system.upload.versionMismatch", new Object[]{invalidVersion.getProvided()})));
    }

    public static final class Result {
        private final boolean success;
        private final String message;

        @ConstructorProperties(value={"success", "message"})
        public Result(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateActionResource.Result(success=" + this.isSuccess() + ", message=" + this.getMessage() + ")";
        }
    }
}

