/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.resources;

import com.plusmpm.util.Authorization;
import com.suncode.autoupdate.plusworkflow.update.State;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.web.support.ajax.RestResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/status"})
public class StatusResource {
    @Autowired
    UpdateEngine engine;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public State getStatus() {
        this.assertFullAdministrationRights();
        return this.engine.getState();
    }

    private void assertFullAdministrationRights() {
        String userName = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)"system.admin", (String)userName, (boolean)false, (boolean)false);
        if (right != 0) {
            throw new SecurityException();
        }
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleSecurityException(SecurityException e) {
        return new RestResult(false);
    }
}

