/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.resources;

import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.plusworkflow.config.Config;
import com.suncode.autoupdate.plusworkflow.config.PropertiesConfigLoader;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import java.io.InputStream;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/configuration"})
public class ConfigurationResource {
    @Autowired
    Context context;
    @Autowired
    UpdateEngine engine;
    @Autowired
    PropertiesConfigLoader configLoader;

    @RequestMapping(value={"version"}, method={RequestMethod.POST})
    @ResponseBody
    public void setVersion(@RequestParam String version) {
        this.context.setCurrentVersion(Jsoup.clean((String)version.trim(), (Safelist)Safelist.basic()));
        this.engine.update("plusworkflow").check();
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public void change(@RequestBody Config config) {
        this.engine.applyConfiguration(config);
    }

    @RequestMapping(value={"parse"}, method={RequestMethod.POST})
    @ResponseBody
    public Config parse(MultipartFile config) {
        return this.parseConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Config parseConfig(MultipartFile config) {
        Config config2;
        InputStream inputStream = config.getInputStream();
        try {
            config2 = this.configLoader.load(inputStream);
        }
        catch (Throwable throwable) {
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return config2;
    }
}

