/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.autoupdate.plusworkflow.config.CorruptedConfigException;
import com.suncode.autoupdate.plusworkflow.util.Consumer;
import com.suncode.autoupdate.server.client.ApiToken;
import com.suncode.autoupdate.server.client.Environment;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;

public class Config {
    public static final String DEFAULT_ADDR = "https://www.aktualizacje.plusworkflow.pl";
    private static final String OLD_DEFAULT_ADDR = "http://www.aktualizacje.plusworkflow.pl";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String systemProject;
    private String systemChannel;
    private URI serverUrl = URI.create("https://www.aktualizacje.plusworkflow.pl");
    private ApiToken apiToken;
    private Environment environment;

    public void save(Consumer<InputStream> consumer) {
        consumer.accept(new ByteArrayInputStream(OBJECT_MAPPER.writeValueAsBytes((Object)this)));
    }

    public static Config read(InputStream inputStream) {
        try {
            Config config = (Config)OBJECT_MAPPER.readValue(inputStream, Config.class);
            if (config.getServerUrl() == null || config.getServerUrl().equals(OLD_DEFAULT_ADDR)) {
                config.setServerUrl(URI.create(DEFAULT_ADDR));
            }
            return config;
        }
        catch (JsonProcessingException e) {
            throw new CorruptedConfigException(e);
        }
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public String getSystemProject() {
        return this.systemProject;
    }

    public String getSystemChannel() {
        return this.systemChannel;
    }

    public URI getServerUrl() {
        return this.serverUrl;
    }

    public ApiToken getApiToken() {
        return this.apiToken;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setSystemProject(String systemProject) {
        this.systemProject = systemProject;
    }

    public void setSystemChannel(String systemChannel) {
        this.systemChannel = systemChannel;
    }

    public void setServerUrl(URI serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setApiToken(ApiToken apiToken) {
        this.apiToken = apiToken;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$systemProject = this.getSystemProject();
        String other$systemProject = other.getSystemProject();
        if (this$systemProject == null ? other$systemProject != null : !this$systemProject.equals(other$systemProject)) {
            return false;
        }
        String this$systemChannel = this.getSystemChannel();
        String other$systemChannel = other.getSystemChannel();
        if (this$systemChannel == null ? other$systemChannel != null : !this$systemChannel.equals(other$systemChannel)) {
            return false;
        }
        URI this$serverUrl = this.getServerUrl();
        URI other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !((Object)this$serverUrl).equals(other$serverUrl)) {
            return false;
        }
        ApiToken this$apiToken = this.getApiToken();
        ApiToken other$apiToken = other.getApiToken();
        if (this$apiToken == null ? other$apiToken != null : !this$apiToken.equals(other$apiToken)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $systemProject = this.getSystemProject();
        result = result * 59 + ($systemProject == null ? 43 : $systemProject.hashCode());
        String $systemChannel = this.getSystemChannel();
        result = result * 59 + ($systemChannel == null ? 43 : $systemChannel.hashCode());
        URI $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : ((Object)$serverUrl).hashCode());
        ApiToken $apiToken = this.getApiToken();
        result = result * 59 + ($apiToken == null ? 43 : $apiToken.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public Config() {
    }

    @ConstructorProperties(value={"systemProject", "systemChannel", "serverUrl", "apiToken", "environment"})
    public Config(String systemProject, String systemChannel, URI serverUrl, ApiToken apiToken, Environment environment) {
        this.systemProject = systemProject;
        this.systemChannel = systemChannel;
        this.serverUrl = serverUrl;
        this.apiToken = apiToken;
        this.environment = environment;
    }

    public Config withSystemProject(String systemProject) {
        return this.systemProject == systemProject ? this : new Config(systemProject, this.systemChannel, this.serverUrl, this.apiToken, this.environment);
    }

    public Config withSystemChannel(String systemChannel) {
        return this.systemChannel == systemChannel ? this : new Config(this.systemProject, systemChannel, this.serverUrl, this.apiToken, this.environment);
    }

    public Config withServerUrl(URI serverUrl) {
        return this.serverUrl == serverUrl ? this : new Config(this.systemProject, this.systemChannel, serverUrl, this.apiToken, this.environment);
    }

    public Config withApiToken(ApiToken apiToken) {
        return this.apiToken == apiToken ? this : new Config(this.systemProject, this.systemChannel, this.serverUrl, apiToken, this.environment);
    }

    public Config withEnvironment(Environment environment) {
        return this.environment == environment ? this : new Config(this.systemProject, this.systemChannel, this.serverUrl, this.apiToken, environment);
    }

    public String toString() {
        return "Config(systemProject=" + this.getSystemProject() + ", systemChannel=" + this.getSystemChannel() + ", serverUrl=" + this.getServerUrl() + ", environment=" + this.getEnvironment() + ")";
    }

    public static class ConfigBuilder {
        private String systemProject;
        private String systemChannel;
        private ApiToken apiToken;
        private Environment environment;
        private URI serverUrl = URI.create("https://www.aktualizacje.plusworkflow.pl");

        ConfigBuilder() {
        }

        public ConfigBuilder systemProject(String systemProject) {
            this.systemProject = systemProject;
            return this;
        }

        public ConfigBuilder systemChannel(String systemChannel) {
            this.systemChannel = systemChannel;
            return this;
        }

        public ConfigBuilder serverUrl(URI serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public ConfigBuilder apiToken(ApiToken apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public ConfigBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Config build() {
            return new Config(this.systemProject, this.systemChannel, this.serverUrl, this.apiToken, this.environment);
        }

        public String toString() {
            return "Config.ConfigBuilder(systemProject=" + this.systemProject + ", systemChannel=" + this.systemChannel + ", serverUrl=" + this.serverUrl + ", apiToken=" + this.apiToken + ", environment=" + this.environment + ")";
        }
    }
}

