/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.plusworkflow.config;

import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.plusworkflow.config.Config;
import com.suncode.autoupdate.plusworkflow.config.PropertiesConfigLoader;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.util.Safe;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.Client;
import com.suncode.pwfl.SystemVersion;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class AutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AutoConfiguration.class);
    private final Context context;
    private final UpdateEngine engine;
    private final PropertiesConfigLoader configLoader;

    @PostConstruct
    public void configure() {
        if (this.engine.isConfigured()) {
            return;
        }
        Safe.safe(this::configureTrial, e -> {
            log.info("Skipping auto-configuration as it failed with an error: " + e.getMessage());
            log.debug("Skipping auto-configuration as it failed with an error: " + e.getMessage(), (Throwable)e);
        });
    }

    private void configureTrial() {
        Optional<Config> config = this.autoUpdateConfig();
        if (!config.isPresent()) {
            log.info("Skipping auto-configuration since no config available");
            return;
        }
        if (!this.context.hasVersion()) {
            Optional<String> revision = this.clientRevision();
            if (revision.isPresent()) {
                this.context.setCurrentVersion(revision.get());
            } else {
                log.info("Skipping auto-configuration since no revision information provided");
                return;
            }
        }
        Config finalConfig = this.withTrial(config.get());
        this.engine.applyConfiguration(finalConfig);
        log.info("Configured updates with config {} and version {}", (Object)finalConfig, (Object)this.context.getCurrentVersion());
    }

    private Config withTrial(Config config) {
        UpdateServerClient client = UpdateServerClient.create();
        if (config.getApiToken() == null) {
            Client trial = client.trialRegistration().registerTrial();
            log.info("Registered new TRIAL auto-update client {}", (Object)trial);
            return config.withApiToken(trial.getApiToken());
        }
        return config;
    }

    private Optional<String> clientRevision() {
        return this.mapResource("client-version.properties", inputStream -> {
            Properties properties = new Properties();
            try {
                properties.load((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String revision = properties.getProperty("revision");
            return StringUtils.isBlank((String)revision) ? null : revision.trim();
        });
    }

    private Optional<Config> autoUpdateConfig() {
        return this.mapResource("autoupdate.properties", this.configLoader::load);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Optional<T> mapResource(String path, Function<InputStream, T> mapper) {
        ClassPathResource resource = new ClassPathResource(path, SystemVersion.class.getClassLoader());
        if (!resource.exists()) return Optional.empty();
        try (InputStream in = resource.getInputStream();){
            Optional<InputStream> optional = Optional.ofNullable(mapper.apply(in));
            return optional;
        }
        catch (Exception e) {
            log.error("Could not read system resource {}", (Object)resource, (Object)e);
        }
        return Optional.empty();
    }

    @ConstructorProperties(value={"context", "engine", "configLoader"})
    @Autowired
    public AutoConfiguration(Context context, UpdateEngine engine, PropertiesConfigLoader configLoader) {
        this.context = context;
        this.engine = engine;
        this.configLoader = configLoader;
    }
}

