auApp.cmp.push(function(Ext) {

    // PROPS
    // target: string
    // patches: array[patch]
    // block: 
    // show:
    // text: 
    // icon: 
    // 
    // CONFIG
    // handler
    // iconRenderer
    return Ext.define("au.UpdateButton", {
        extend: Ext.button.Split,
        xtype: 'auUpdateButton',
        mixins: {
            stateAware: 'au.StateAware',
            action: 'au.ActionButtonMixin'
        },
        menuAlign: "tl-bl?",

        constructor: function(props) {
            function bind(prop, currentFn) {
                return function(state, me, current) {
                    if(currentFn) {
                        current(currentFn.call(this))
                    }
                    return prop(state);
                }
            }

            this.props = props;
            this.stateAware = {
                setVisible: function(state, me){
                    return props.patches(state).length > 0 && props.show(state);
                },
                setIconCls: function(state, me, current) {
                    if(me.isInProgress()) {
                        return me.iconCls;
                    }
                    return props.icon(state);
                },
                setText: bind(props.text),
                setInProgress: bind(props.block, this.isInProgress)
            };

            this.handler = function() {
                target = optionalProp(props.target, au.State.get());
                if(target){
                    this.invokeHandler(target);
                }
                else {
                    this.showMenu();
                }
            };

            this.callParent();
        },

        initComponent: function () {
            const me = this;

            this.callParent();

            this.arrowHandler = function () {
                me.showMenu();
            };

            this.mixins.stateAware.init.call(this);
        },

        showMenu: function () {
            const state = au.State.get();
            const patches = this.props.patches(state);

            if (patches.length > 0) {
                const newMenu = this.createPatchesMenu(patches, this.props.iconRenderer, function (grid, record, item, index) {
                    this.invokeHandler(record.get("toVersion"));
                    this.hideMenu();
                }.bind(this));

                if (this.menu && this.menu.isMenu) {
                    this.menu.destroy();
                }

                this.menu = newMenu;
            }

            if (this.menu && this.menu.isMenu) {
                this.callParent(arguments);
            }
        },

        invokeHandler: function(version) {
            this.props.handler(this.lookupPatch(version));
        },

        lookupPatch: function(version) {
            var patches = this.props.patches(au.State.get());
            return Ext.Array.findBy(patches, function(patch) {
                return patch.toVersion == version;
            });
        },

        createPatchesMenu: function(patches, iconRenderer, handler) {
            return new Ext.menu.Menu({
                border: false,
                items: [
                    Ext.create('Ext.grid.Panel', {
                        store: Ext.create('Ext.data.Store', {
                            fields:['id', 'toVersion', 'validation'],
                            data:{'patches': patches},
                            proxy: {
                                type: 'memory',
                                reader: {
                                    type: 'json',
                                    root: 'patches'
                                }
                            }
                        }),
                        cls: "au-patches",
                        style: "border: 0; padding: 10px;",
                        border: false,
                        hideHeaders: true,
                        listeners: {
                            itemclick: handler
                        },
                        columns: [
                            { dataIndex: 'toVersion', flex: 1 },
                            { dataIndex: 'validation', renderer: function(validation, meta){
                                meta.style = 'text-align: center;';
                                return '<img src="' + Ext.BLANK_IMAGE_URL + '" class="' + iconRenderer(validation) + '" style="height: 16px; width:16px;"/>';
                            } }
                        ],
                        width: 400,
                        maxHeight: 600
                    })
                    ]
                });
        }
    });

    function optionalProp(prop, state) {
        return prop ? prop(state) : undefined;
    }

});
