auApp.cmp.push(function(Ext) {

    var mapping = {
        checksumAdded: {
            type: "ERROR",
            order: 1
        },
        checksumUpdated: {
            type: "ERROR",
            order: 2
        },
        checksumDeleted: {
            type: "ERROR",
            order: 3
        },
        checksum: {
            type: "ERROR",
            order: 4
        },
        missing: {
            type: "ERROR",
            order: 5
        },
        extra: {
            type: "WARN",
            order: 6
        },
        added: {
            type: "INFO",
            order: 7
        },
        updated: {
            type: "INFO",
            order: 8
        },
        deleted: {
            type: "INFO",
            order: 9
        }
    };

    var DetailItem= Ext.define('au.DetailItem', {
        extend: 'Ext.data.Model',
        fields: [
            {name: 'path' },
            {name: 'type' },
            {name: 'typeText' },
            {name: 'severity' },
            {name: 'order' },
        ]
    });

    function mapToDetails(root) {
        var data = [];
        Ext.Object.each(root, function(key, value) {
            var mapped = mapping[key];
            if (mapped) {
                Ext.Array.each(value, function(path) {
                    data.push(DetailItem.create({
                        path: path,
                        type: key,
                        typeText: au.t("update.details.type." + key),
                        severity: mapped.type,
                        order: mapped.order
                    }));
                });
            }
        });
        return data;
    }

    Ext.define('au.UpdateDetails', {
        extend: 'Ext.window.Window',
        xtype: 'auUpdateDetails',
        title: au.t("update.details"),
        modal: true,
        layout: 'fit',
        initComponent: function() {
            var validation = this.update.properties.validationResult;
            var validationDetails = mapToDetails(validation);

            var changelogReader = new Ext.data.reader.Json({
                    readRecords: function(changelog){
                        var data = mapToDetails(changelog).concat(validationDetails);
                        return new Ext.data.ResultSet({
                            total  : data.length,
                            count  : data.length,
                            records: data,
                            success: true,
                        });
                    }
            });

            var store = Ext.create('Ext.data.Store', {
                model: DetailItem,
                proxy: {
                    type: 'ajax',
                     url: auApp.basePath + '/updates/' + 'plusworkflow' + '/changelog',
                     reader: changelogReader
                 },
                 autoLoad: true,
                 sorters: [{
                     property: 'path'
                 }],
                 groupField: 'order'
             });

            this.items = [{
                xtype: 'grid',
                store: store,
                width: 600,
                height: 350,
                features: [{
                    ftype: 'grouping',
                    groupHeaderTpl: [
                        '<div data-severity="{children:this.severity}">{children:this.type} ({rows.length})</div>',
                        {
                            type: function(children) {
                                return children[0].get('typeText');
                            },
                            severity: function(children) {
                                return children[0].get('severity');
                            }
                        }
                    ],
                    startCollapsed: true
                }],
                columns: [{
                    text: au.t("update.details.path"),
                    flex: 1,
                    dataIndex: 'path'
                }]
            }];
            this.bbar = ['->', {
                text: au.t("update.details.copy"),
                iconCls: 'dvnt-icon-copy',
                handler: this.copyToClipboard,
                scope: this,
                cls: 'au-copy-clipboard'
            }]
            this.callParent();
        },

        copyToClipboard: function() {
            if (!this.clipboard) {
                var output = JSON.stringify(this.update.properties.validationResult, null, 2);
                this.clipboard = new Clipboard(".au-copy-clipboard", {
                    text: function() {
                        return output;
                    }
                });
            }
        },
        destroy: function() {
            if (this.clipboard) {
                this.clipboard.destroy();
            }
            this.callParent(arguments);
        }
    });
});
