window.auApp.cmp.push(function(Ext) {

    Ext.define("au.ConfigPopup", {
        extend: 'Ext.window.Window',
        xtype: 'auConfig',
        singleton: true,
        mixins: {
            stateAware: 'au.StateAware'
        },
        title: au.t("updates.configuration"),
        width: 800,
        modal: true,
        closeAction: "hide",
        layout: {
            type: 'hbox',
            align: 'stretch'
        },
        defaults: {
            bodyPadding: 10
        },
        items: [{
            xtype: "form",
            itemId: "configForm",
            layout: 'form',
            flex: 2,
            border: false,
            defaults: {
                labelWidth: 150
            },
            items: [{
                xtype: "textfield",
                name: "systemProject",
                fieldLabel: au.t("updates.configuration.project")
            }, {
                xtype: "textfield",
                name: "systemChannel",
                fieldLabel: au.t("updates.configuration.channel")
            }, {
                xtype: "textfield",
                name: "apiToken",
                fieldLabel: au.t("updates.configuration.token")
            }, {
                xtype: "textfield",
                name: "environment",
                fieldLabel: au.t("updates.configuration.env")
            }, {
                xtype: "textfield",
                name: "serverUrl",
                fieldLabel: au.t("updates.configuration.server")
            }]
        }, {
            xtype: 'form',
            width: 260,
            layout: 'form',
            items: [{
                xtype: 'toolbar',
                style: "background-color: rgba(233, 250, 234, 0.95); border-radius: 8px;",
                items: [au.t("updates.configuration.load.desc")]
            }, {
                xtype: 'filefield',
                name: 'config',
                itemId: "configField",
                allowBlank: false,
                buttonText: '',
                regex: /\.properties/i
            }]
        }],
        buttons: [{
            text: au.t("updates.configuration.save"),
            itemId: "saveBtn"
        }],
        initComponent: function() {
            this.callParent(arguments);
            this.mixins.stateAware.init.call(this);
            this.down("#saveBtn").on("click", this.save, this);

            this.on("afterrender", this.doLayout);

            var configForm = this.down("#configForm");
            this.down("#configField").on("change", function() {
                var form = this.up("form").getForm();
                if (form.isValid()) {
                    form.submit({
                        url: auApp.basePath + '/configuration/parse',
                        failure: function(form, action) {
                            if (action.result) {
                                configForm.getForm()
                                    .setValues({
                                        "systemProject": action.result.systemProject,
                                        "systemChannel": action.result.systemChannel,
                                        "apiToken": action.result.apiToken.token,
                                        "environment": action.result.environment.env,
                                        "serverUrl": action.result.serverUrl
                                    });
                            }
                        }
                    });
                }
            });
        },
        show: function() {
            var state = au.State.get();
            if (state.config) {
                this.down("#configForm").getForm()
                    .setValues({
                        "systemProject": state.config.systemProject,
                        "systemChannel": state.config.systemChannel,
                        "apiToken": state.config.apiToken.token,
                        "environment": state.config.environment.env,
                        "serverUrl": state.config.serverUrl
                    });
            }
            this.callParent();
        },
        save: function() {
            var me = this;
            var form = this.down("#configForm").getForm();
            if (form.isValid()) {
                var values = form.getValues();
                var config = {
                    systemProject: values.systemProject,
                    systemChannel: values.systemChannel,
                    apiToken: {
                        token: values.apiToken
                    },
                    environment: {
                        env: values.environment
                    },
                    serverUrl: values.serverUrl
                };
                jQuery.ajax({
                        method: 'POST',
                        url: auApp.basePath + '/configuration',
                        data: JSON.stringify(config),
                        contentType: "application/json",
                        dataType: 'json'
                    })
                    .done(function() {
                        me.hide();
                        au.State.reload();
                    });
            }
        }
    });

    au.State.bind(function(state) {
        if (!au.ConfigPopup.isVisible() && !state.configured) {
            au.ConfigPopup.show();
        }
    });
});
