auApp.cmp.push(function(Ext) {

    var items = [];
    // TODO: on state change
    Ext.Object.each(au.State.get().updates, function(key, update){
      if(key != 'plusworkflow') {
        items.push({
          xtype: 'auPluginUpdate',
          project: key,
          displayName: update.displayName
        });
      }
    });

    sortByDisplayName(items);

    Ext.define('au.ComponentUpdates', {
        extend: 'Ext.Panel',
        xtype: 'auComponentUpdates',
        title: au.t("update.plugins"),
        items: items,
        bodyStyle: {
            border: '0'
        }
    });
});

function sortByDisplayName(items) {
    items.sort((a, b) => {
        const nameA = a.displayName.toUpperCase();
        const nameB = b.displayName.toUpperCase();

        if (nameA < nameB) {
            return -1;
        }
        if (nameA > nameB) {
            return 1;
        }
        return 0;
    });
}
