auApp.cmp.push(function(Ext) {

    const prop = au.StateAware.prop;

    // PROPS
    // href: string
    // show: boolean
    return Ext.define("au.Button", {
        extend: Ext.button.Button,
        xtype: 'auButton',
        mixins: {
            stateAware: 'au.StateAware'
        },
        preventDefault: false,

        stateAware: [
            prop("href", (href, cmp) => {
                if(cmp.rendered) {
                    cmp.setHref(href)
                    cmp.el.dom.target = cmp.hrefTarget
                }
                else {
                    cmp.href = href;
                }
            }),
            prop("show", (show, cmp) => cmp.setVisible(show)),
        ],

        initComponent: function() {
            this.callParent();
            this.mixins.stateAware.init.call(this);
        }
    });
});
