window.auApp.cmp.push(function(Ext) {

    Ext.define("au.ActionButtonMixin", {
        inProgress: false,

        isInProgress: function() {
            return this.inProgress;
        },

        setInProgress: function(progress) {
            if(this.inProgress == progress) {
              return;
            }

            if (progress) {
                this.beforeIconCls = this.iconCls;
                this.inProgress = true;
                this.setDisabled(true);
                this.setIconCls("x4-mask-msg-text");
            } else {
                this.inProgress = false;
                this.setDisabled(false);
                this.setIconCls(this.beforeIconCls);
                delete this.beforeIconCls;
            }
        }
    });

    return Ext.define("au.ActionButton", {
        extend: 'Ext.button.Button',
        xtype: 'auActionButton',

        mixins: {
            action: 'au.ActionButtonMixin'
        }
    });
});
