package com.suncode.autoupdate.plusworkflow.util;

import com.suncode.plugin.framework.PluginStoreResource;
import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.function.Function;

@Slf4j
@UtilityClass
public class Safe {

    public static <T> T safe(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        } catch (Exception e) {
            log.warn("Exception when invoking safe action", e);
            return defaultValue;
        }
    }

    public static <T> T safeNoLog(Callable<T> callable, T defaultValue) {
        try {
            return callable.call();
        } catch (Exception e) {
            return defaultValue;
        }
    }

    public static void safe(Runnable routine, Consumer<Exception> handleError) {
        try {
            routine.run();
        } catch (Exception e) {
            if (handleError != null) {
                handleError.accept(e);
            } else {
                log.warn("Exception when invoking safe action", e);
            }
        }
    }

    @SneakyThrows
    public static <T> T withInputStream(PluginStoreResource resource, Function<InputStream, T> fn) {
        try (InputStream in = resource.getInputStream()) {
            return fn.apply(in);
        }
    }
}
