package com.suncode.autoupdate.plusworkflow.util;

import lombok.experimental.UtilityClass;

import java.util.Arrays;
import java.util.function.Predicate;

@UtilityClass
public class Predicates {

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T>... predicates) {
        return Arrays.stream(predicates).reduce(alwaysFalse(), Predicate::and);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return t -> false;
    }
}
