package com.suncode.autoupdate.plusworkflow.util;

import lombok.experimental.UtilityClass;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@UtilityClass
public class Maps
{
    public static <T, K, V> Map<K, V> of(
        T[] elementsArr,
        Function<T, K> keyFunction,
        Function<T, V> valueFunction
    )
    {
        return Arrays.stream(elementsArr).collect( Collectors.toMap( keyFunction, valueFunction ) );
    }
}
