package com.suncode.autoupdate.plusworkflow.util;

import com.google.common.collect.Iterables;
import lombok.experimental.UtilityClass;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

import static com.google.common.collect.Iterables.getFirst;

@UtilityClass
public class Collections {

    public static <T, R> Optional<R> first(Iterable<T> iterable, Function<T, R> mapFn) {
        return Optional.ofNullable(getFirst(iterable, null))
                .map(mapFn);
    }

    public static <T> T last(Iterable<T> iterable) {
        return Objects.requireNonNull(Iterables.getLast( iterable, null ));
    }
}
