package com.suncode.autoupdate.plusworkflow.update.system;

import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdater;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;

@Order(1)
@Component
@RequiredArgsConstructor( onConstructor = @__( @Autowired ) )
public class SystemUpdater
    implements ComponentUpdater, Ordered
{
    private final SystemUpdate systemUpdate;
    private final TomcatHook hook;

    @PostConstruct
    public void installHook()
    {
        hook.install();
    }

    @Override
    public Collection<ComponentUpdate> getComponents()
    {
        return Collections.<ComponentUpdate> singleton( systemUpdate );
    }

    @Override
    public int getOrder() {
        return 1;
    }
}
