package com.suncode.autoupdate.plusworkflow.update.system;

import java.io.File;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.annotation.DateTimeFormat.ISO;

import com.suncode.autoupdate.patcher.Context;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class Rollback
{
    String fileName;
    String from;
    String to;
    @DateTimeFormat( iso = ISO.DATE_TIME )
    Date applied;
    
    public File resolve(Context context) {
        return new File(context.getRoot(), ".patcher/backups/" + fileName);
    }
}
