package com.suncode.autoupdate.plusworkflow.update.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.plusworkflow.update.PendingPatch;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import lombok.Data;
import lombok.experimental.FieldDefaults;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static com.suncode.autoupdate.plusworkflow.util.Collections.last;
import static lombok.AccessLevel.PRIVATE;

@Data
@FieldDefaults( level = PRIVATE )
public class UpdateContext
{
    Date lastCheck;
    Patches patches;
    Map<String, Object> properties = new HashMap<>();

    List<PendingPatch> patchesToApply;
    Date applyAfter;
    Rollback rollback;

    public Patches getPatches() {
        return Optional.ofNullable(patches).orElseGet(Patches.NoPatches::new);
    }

    @JsonIgnore
    public Optional<String> getNewestVersion()
    {
        return getPatches().getNewestVersion();
    }

    @JsonIgnore
    public PendingPatch getTargetPatch()
    {
        Preconditions.checkState( !patchesToApply.isEmpty() );

        return last( patchesToApply );
    }
}
