package com.suncode.autoupdate.plusworkflow.update.support;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Func;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import lombok.Getter;
import lombok.Setter;
import lombok.SneakyThrows;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.EnumSet;

import static com.suncode.autoupdate.plusworkflow.util.Safe.safeNoLog;

public class PersistState
        implements Func<UpdateState>, Action1<UpdateState> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper()
        .registerModule( new Jdk8Module() );

    private final PluginStore store;

    private Serialized state;

    public PersistState(PluginStore store) {
        this.store = store;
        this.state = load();
    }

    public UpdateContext getPersistedContext() {
        return state.context;
    }

    @Override
    public void doIt(UpdateState arg1) {
        state.state = arg1;
        persist();
    }

    @Override
    public UpdateState call() {
        return state.state;
    }

    @SneakyThrows
    private void persist() {
        EnumSet<UpdateState> persistent = EnumSet.of(UpdateState.POSTPONED_BACKUP, UpdateState.POSTPONED_UPDATE);
        if (persistent.contains(state.state)) {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes(state);
            store.store("state", new ByteArrayInputStream(bytes), true);
        }
    }

    @SneakyThrows
    private Serialized load() {
        PluginStoreResource read = store.read("state");
        if (read == null) {
            return new Serialized();
        }

        // state is not fully persistable - so in case of restart its ok to just reset state (fixing it requires significant amount of effort)
        return safeNoLog(() -> {
            try (InputStream in = read.getInputStream()) {
                return OBJECT_MAPPER.readValue(in, Serialized.class);
            }
        }, new Serialized());
    }

    @Getter
    @Setter
    @JsonIgnoreProperties(ignoreUnknown = true)
    private static class Serialized {
        UpdateContext context = new UpdateContext();
        UpdateState state = UpdateState.INITIAL;
    }
}
