package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.suncode.plugin.framework.PluginControl.Validation;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Provided;
import com.suncode.plugin.framework.requirements.Required;
import com.suncode.plugin.framework.requirements.Requirement;
import com.suncode.plugin.framework.requirements.Resolution;
import lombok.Getter;
import lombok.Value;

import java.util.List;
import java.util.Set;

import static com.suncode.pwfl.util.Predicates.not;
import static java.util.stream.Collectors.toSet;
import static lombok.AccessLevel.NONE;


@Value
public class ValidationView {
    MandatoryOrOptional missing;
    MandatoryOrOptional provided;

    public ValidationView(Validation validation) {
        this.missing = new MandatoryOrOptional(
                validation.getRequired()
                        .stream()
                        .map(Mismatch::of)
                        .collect(toSet()));
        this.provided = new MandatoryOrOptional(
                validation.getProvided()
                        .stream()
                        .map(Mismatch::of)
                        .collect(toSet()));
    }

    public boolean isValid() {
        return missing.items.isEmpty() && provided.items.isEmpty();
    }

    @Value
    public static class MandatoryOrOptional {
        @Getter(NONE)
        Set<Mismatch> items;

        public Set<Mismatch> getMandatory() {
            return items.stream()
                    .filter(Mismatch::isMandatory)
                    .collect(toSet());
        }

        public Set<Mismatch> getOptional() {
            return items.stream()
                    .filter(not(Mismatch::isMandatory))
                    .collect(toSet());
        }
    }

    @Value
    public static class Mismatch {
        String key;
        List<Version> requiredVersions;
        Resolution resolution;
        boolean mandatory;

        public static Mismatch of(Required required) {
            Requirement requirement = required.getRequirement();
            return new Mismatch(
                    requirement.getPluginKey(),
                    requirement.getRequiredVersions(),
                    required.getResolution(),
                    requirement.isMandatory()
            );
        }

        public static Mismatch of(Provided provided) {
            Reference ref = Reference.of(provided.getPlugin());
            return new Mismatch(
                    ref.getId(),
                    provided.getRequired().getRequirement().getRequiredVersions(),
                    provided.getRequired().getResolution(),
                    provided.getRequired().getRequirement().isMandatory()
            );
        }
    }
}
