package com.suncode.autoupdate.plusworkflow.update.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdater;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.PluginFramework;
import lombok.RequiredArgsConstructor;
import lombok.experimental.FieldDefaults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

import static lombok.AccessLevel.PRIVATE;

@Component
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@FieldDefaults(level = PRIVATE, makeFinal = true)
public class PluginsUpdater
        implements ComponentUpdater, Ordered {
    public static final String RELEASE_CHANNEL = "release";

    PluginFramework plugins;
    PluginUpdate.Factory factory;
    ConcurrentMap<String, PluginUpdate> pluginUpdates = Maps.newConcurrentMap();


    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public Collection<ComponentUpdate> getComponents() {
        sync();
        return Lists.<ComponentUpdate>newArrayList(pluginUpdates.values());
    }

    private void sync() {
        for (Plugin plugin : plugins.getPlugins()) {
            if (!pluginUpdates.containsKey(plugin.getKey())) {
                pluginUpdates.putIfAbsent(plugin.getKey(), factory.releaseChannel(plugin));
            }
        }

        for (String plugin : pluginUpdates.keySet()) {
            if (!plugins.isInstalled(plugin)) {
                pluginUpdates.remove(plugin);
            }
        }
    }
}
