package com.suncode.autoupdate.plusworkflow.update.engine;

import lombok.experimental.FieldDefaults;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.util.List;

import static java.time.temporal.ChronoUnit.MINUTES;
import static lombok.AccessLevel.PRIVATE;

@Component
@Slf4j
@FieldDefaults(level = PRIVATE)
public class Updates {
    @Autowired
    List<ComponentUpdater> updaters;

    volatile Instant lastChecked;

    @Async
    public void checkAll() {
        Instant now = Instant.now();
        if (lastChecked == null || lastChecked.isBefore(now.minus(1, MINUTES))) {
            lastChecked = now;

            updaters.stream()
                    .sorted(OrderComparator.INSTANCE)
                    .forEach(updater -> {
                        for (ComponentUpdate component : updater.getComponents()) {
                            log.debug("Checking updates for component {}", component.key());
                            component.check();
                        }
                    });
        }
    }
}
