package com.suncode.autoupdate.plusworkflow.update.engine;

import com.suncode.autoupdate.plusworkflow.update.Changelog;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.autoupdate.plusworkflow.update.Updates;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;
import lombok.Value;

import java.io.InputStream;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;

import static lombok.AccessLevel.PRIVATE;

public interface ComponentUpdate
{
    String key();
    UpdateState state(); 
    Updates getUpdates();
    Changelog getPendingChangelog();

    void check();
    void updateTo(String version);
    void confirm(Date when);
    void cancel();
    void rollback(Rollback rollback);

    ApplyResult apply(InputStream patch);


    @Value
    @RequiredArgsConstructor(access = PRIVATE)
    class ApplyResult {
        InvalidVersion invalid;

        public <T> T fold(
                Supplier<T> ok,
                Function<InvalidVersion, T> invalidVersion
        ) {
            return invalid != null
                    ? invalidVersion.apply(invalid)
                    : ok.get();
        }

        public static ApplyResult ok() {
            return new ApplyResult(null);
        }

        public static ApplyResult invalidVersion(String required, String provided) {
            return new ApplyResult(new InvalidVersion(required, provided));
        }
    }

    @Value
    class InvalidVersion {
        String required;
        String provided;
    }
}