package com.suncode.autoupdate.plusworkflow.update.download;

import static com.google.common.base.Preconditions.checkState;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.plugin.framework.PluginStoreResource;

import lombok.Builder;
import lombok.NonNull;
import lombok.Singular;
import lombok.SneakyThrows;
import lombok.Value;

@Value
@Builder
public class Download
{
    @NonNull
    @Singular
    Map<Patch, Future<PluginStoreResource>> tasks;

    @SneakyThrows
    public void await()
    {
        for ( Future<?> futures : tasks.values() )
        {
            try
            {
                futures.get();
            }
            catch ( ExecutionException e )
            {
                throw e.getCause();
            }
        }
    }
    
    @SneakyThrows
    public PluginStoreResource patchArchive(Patch patch) {
        Future<PluginStoreResource> future = tasks.get( patch );
        checkState( future.isDone() );
        return future.get();
    }
}
