package com.suncode.autoupdate.plusworkflow.resources;

import com.suncode.autoupdate.patch.glowroot.GlowrootTransactionTypes;
import com.suncode.autoupdate.plusworkflow.update.Changelog;
import com.suncode.autoupdate.plusworkflow.update.engine.ComponentUpdate;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.plusworkflow.update.system.Rollback;
import com.suncode.plugin.framework.Plugin;
import lombok.SneakyThrows;
import lombok.Value;
import org.glowroot.agent.api.Glowroot;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.annotation.DateTimeFormat.ISO;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@Controller
@RequestMapping("/updates")
public class UpdateActionResource {
    @Autowired
    private UpdateEngine engine;
    @Autowired
    private Plugin plugin;

    @RequestMapping(value = "/{project}/apply", method = RequestMethod.POST)
    public @ResponseBody
    void applyPlugin( @PathVariable String project, @RequestParam String version ) {
        Glowroot.setTransactionType( GlowrootTransactionTypes.AUTO_UPDATE_PLUGIN );
        Glowroot.setTransactionName( String.format( "Auto update plugin [%s]", project ) );

        ComponentUpdate update = engine.update( project );
        update.updateTo( version );
    }

    @RequestMapping(value = "/{project}/apply/confirm", method = RequestMethod.POST)
    public @ResponseBody
    void confirm(@PathVariable String project,
                @RequestParam(required = false) @DateTimeFormat(iso = ISO.DATE_TIME) Date when
    ) {
        ComponentUpdate update = engine.update(project);
        update.confirm( when );
    }

    @RequestMapping(value = "/{project}/cancel", method = RequestMethod.POST)
    public @ResponseBody
    void cancel(@PathVariable String project) {
        ComponentUpdate update = engine.update(project);
        update.cancel();
    }

    @RequestMapping(value = "/{project}/check", method = RequestMethod.POST)
    public @ResponseBody
    void check(@PathVariable String project) {
        ComponentUpdate update = engine.update(project);
        update.check();
    }

    @RequestMapping(value = "/{project}/rollback", method = RequestMethod.POST)
    public @ResponseBody
    void rollback(@PathVariable String project, @RequestBody Rollback rollback) {
        ComponentUpdate update = engine.update(project);
        update.rollback(rollback);
    }

    @RequestMapping(value = "/{project}/changelog", method = GET)
    @ResponseBody
    public Changelog getChangelog(@PathVariable String project) {
        return engine.update(project).getPendingChangelog();
    }

    @SneakyThrows
    @RequestMapping(value = "/{project}/upload", method = RequestMethod.POST)
    public @ResponseBody
    Result upload(@PathVariable String project, @RequestParam("file") MultipartFile file) {
        return engine.update(project).apply(file.getInputStream())
                .fold(
                        () -> new Result(true, ""),
                        (invalidVersion) -> new Result(
                                false,
                                plugin.getMessage("system.upload.versionMismatch", invalidVersion.getProvided() ))
                );
    }
    
    @Value
    public static class Result {
        boolean success;
        String message;
    }
}
