package com.suncode.autoupdate.plusworkflow.resources;

import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.web.support.ajax.RestResult;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.suncode.autoupdate.plusworkflow.update.State;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping( "/status" )
public class StatusResource
{
    @Autowired
    UpdateEngine engine;

    @RequestMapping( method = RequestMethod.GET )
    @ResponseBody
    public State getStatus()
    {
        assertFullAdministrationRights();
        return engine.getState();
    }

    @SneakyThrows
    private void assertFullAdministrationRights( )
    {
        String userName = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight( "system.admin", userName, false, false );
        if ( right != Authorization.nFULL )
        {
            throw new SecurityException();
        }
    }

    @ExceptionHandler( { SecurityException.class } )
    @ResponseStatus( HttpStatus.FORBIDDEN )
    @ResponseBody
    public RestResult handleSecurityException( SecurityException e )
    {
        return new RestResult( false );
    }
}
