package com.suncode.autoupdate.plusworkflow.resources;

import java.io.InputStream;

import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.plusworkflow.config.Config;
import com.suncode.autoupdate.plusworkflow.config.PropertiesConfigLoader;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;

import lombok.SneakyThrows;

@Controller
@RequestMapping( "/configuration" )
public class ConfigurationResource
{
    @Autowired
    Context context;
    
    @Autowired
    UpdateEngine engine;
    
    @Autowired
    PropertiesConfigLoader configLoader;
    
    @RequestMapping( value="version", method = RequestMethod.POST )
    public @ResponseBody void setVersion( @RequestParam String version )
    {
        context.setCurrentVersion( Jsoup.clean( version.trim(), Safelist.basic() ) );
        engine.update("plusworkflow").check();
    }
    
    @RequestMapping( method = RequestMethod.POST )
    public @ResponseBody void change( @RequestBody Config config)
    {
        engine.applyConfiguration( config );
    }
    
    @RequestMapping( value="parse", method = RequestMethod.POST )
    public @ResponseBody Config parse( MultipartFile config )
    {
        return parseConfig( config );
    }

    @SneakyThrows
    private Config parseConfig( MultipartFile config )
    {
        InputStream inputStream = config.getInputStream();
        try
        {
            return configLoader.load( inputStream );
        }
        finally
        {
            inputStream.close();
        }
    }
}
