package com.suncode.autoupdate.plusworkflow.audit;

import com.suncode.autoupdate.plusworkflow.util.Maps;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.audit.plugin.PluginAuditProvider;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

public class Audits implements PluginAuditProvider
{

    @Autowired
    private Plugin messageSource;

    @Override
    public Map<String, String> getPluginAudits()
    {
        return Maps.of( Audit.values(), Audit::key, audit -> messageSource.getMessage( audit.key() ));
    }
}
