package com.suncode.autoupdate.plusworkflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.suncode.autoupdate.patcher.Context;
import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.plugin.framework.web.mvc.MvcModuleConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableScheduling;

import javax.servlet.ServletContext;
import java.io.File;

@Configuration
@EnableScheduling
public class PluginContext
{
    @Autowired
    private UpdateEngine engine;
    
    @Bean
    public Context patcherContext( ServletContext servletContext )
    {
        return new Context( new File( servletContext.getRealPath( "" ) ) );
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper()
                .registerModule(new ParameterNamesModule())
                .registerModule(new Jdk8Module());
    }

    @Bean
    public MvcModuleConfigurer mvcModuleConfigurer(ObjectMapper objectMapper) {
        return converters -> {
            MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
            converter.setObjectMapper(objectMapper);
            converters.add(0, converter);
        };
    }
}
