window.auApp.cmp.push(function(Ext) {

    return Ext.define("au.Updates", {
        extend: 'Ext.Panel',
        xtype: 'auUpdates',
        mixins: {
            stateAware: 'au.StateAware'
        },
        stateAware: {
            setDisabled: function(state, cmp, current) {
                current(this.isDisabled());
                return !state.configured;
            }
        },
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        bodyStyle: "background: none; border: 0",
        items: [{
            xtype: 'auSystemUpdates',
            bodyStyle: "border: 0",
            flex: 1
        }, {
            xtype: "container",
            height: 30,
            style: "background: none"
        }, {
            xtype: 'auComponentUpdates',
            flex: 1
        }],
        bbar: {
            items: [{
                xtype: "button",
                text: au.t("updates.configuration"),
                iconCls: 'dvnt-icon-settings',
                handler: function() {
                    au.ConfigPopup.show();
                }
            }]
        },
				initComponent: function() {
						this.callParent();
						this.mixins.stateAware.init.call(this);
				}
    });
});
