window.auApp.cmp.push(function(Ext) {
    // CONFIG
    // buttons
    return Ext.define("au.Update", {
        extend: 'Ext.Panel',
        collapsible: true,
        collapsed: true,
        titleCollapse: true,
        animCollapse: false,
        cls: ['au-component-update'],
        bodyPadding: "1 0 1 5",
        mixins: {
            stateAware: 'au.StateAware'
        },
        stateAware: {
            setTitle: function(state, cmp) {
                return cmp.titleText(cmp.updateFromState(state), state);
            },
            stateChanged: Ext.identityFn
        },

        constructor: function(config) {
            var buttons = config.buttons || [{
                xtype: 'auActionButton',
                itemId: 'download-newest-btn',
                iconCls: 'dvnt-icon-check-circle dvnt-green-icon',
                text: au.t("update.toVersion"),
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'UPDATES_AVAILABLE' ||
                            update.state == 'DOWNLOADING' ||
                            update.state == 'DOWNLOADED' ||
                            update.state == 'VALIDATING' ||
                            update.state == 'APPLYING';
                    },
                    setText: function(state, cmp) {
                        return cmp.updateToNewestText(cmp.updateFromState(state), state, this);
                    },
                    setInProgress: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'DOWNLOADING' ||
                            update.state == 'DOWNLOADED' ||
                            update.state == 'VALIDATING' ||
                            update.state == 'READY' ||
                            update.state == 'APPLYING';
                    }
                }
            }, {
                xtype: 'auActionButton',
                itemId: 'download-btn',
                iconCls: 'dvnt-icon-check-circle dvnt-green-icon',
                text: au.t('update.to'),
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return (update.updates.patches || []).length > 1 && (update.state == 'UPDATES_AVAILABLE' ||
                            update.state == 'DOWNLOADING' ||
                            update.state == 'DOWNLOADED' ||
                            update.state == 'VALIDATING' ||
                            update.state == 'APPLYING');
                    },
                    setText: function(state, cmp) {
                        return cmp.updateToSpecificText(cmp.updateFromState(state), state, this);
                    },
                    setInProgress: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'DOWNLOADING' ||
                            update.state == 'DOWNLOADED' ||
                            update.state == 'VALIDATING' ||
                            update.state == 'READY' ||
                            update.state == 'APPLYING';
                    }
                }
            }];

            Ext.apply(this, {
                defaults: {
                    labelWidth: 150,
                    cls: 'au-update-field'
                },
                bodyPadding: 10,
                layout: 'form',
                items: [...config.items || [], {
                    xtype: "displayfield",
                    fieldLabel: au.t("update.current.version"),
                    stateAware: {
                        setValue: function(state, cmp) {
                            return cmp.currentVersionFieldValue(cmp.updateFromState(state), state, this);
                        }
                    }
                }, {
                    xtype: "displayfield",
                    fieldLabel: au.t("update.channel"),
                    fieldCls: 'au-update-label',
                    stateAware: {
                        setValue: function(state, cmp) {
                            return cmp.updateFromState(state).channel;
                        }
                    }
                }],
                bbar: {
                    stateAwareFixLayout: true,
                    items: buttons.concat([ '->', {
                        xtype: 'tbtext',
                        textTpl: au.t("update.check.last"),
                        stateAware: {
                            setText: function(state, cmp) {
                                var lastCheck = cmp.updateFromState(state).lastCheck;
                                var formatted = Ext.Date.format(Ext.Date.parse(lastCheck, 'time'), 'Y-m-d H:i:s');
                                return Ext.String.format(this.textTpl, formatted);
                            }
                        },
                    }, {
                        xtype: 'auActionButton',
                        iconCls: 'dvnt-icon-rotation-right dvnt-green-icon',
                        text: au.t("update.check.now"),
                        itemId: 'check-btn',
                        stateAware: {
                            setDisabled: function(state, cmp) {
                                var update = cmp.updateFromState(state);
                                return !(update.state == 'UPDATES_AVAILABLE' ||
                                    update.state == 'UP_TO_DATE' ||
                                    update.state == 'NO_UPDATES' ||
                                    update.state == 'DOWNLOADED' ||
                                    update.state == 'ERROR');
                            },
                            setInProgress: function(state, cmp) {
                                var update = cmp.updateFromState(state);
                                return update.state == 'CHECKING';
                            }
                        }
                    }])
                }
            });
            this.callParent();
        },

        initComponent: function() {
            this.callParent();
            this.mixins.stateAware.init.call(this);

            this.downloadNewestBtn = this.down('#download-newest-btn');
            this.downloadBtn = this.down('#download-btn');
            this.checkBtn = this.down('#check-btn');

            if(this.downloadNewestBtn) this.downloadNewestBtn.on('click', this.updateToNewest, this);
            if(this.downloadBtn) this.downloadBtn.on('click', this.updateTo, this);
            if(this.checkBtn) this.checkBtn.on('click', this.checkNow, this);
        },
        updateFromState: function(state) {
            return state.updates[this.project];
        },
        updateToNewest: function() {
            var update = this.updateFromState(au.State.get());
            this.updateToVersion(update.newestVersion);
        },
        updateToVersion: function(version) {
            var update = this.updateFromState(au.State.get());
            update.state = 'APPLYING';
            au.State.changed();
            jQuery.post(auApp.basePath + '/updates/' + this.project + '/apply?version=' + version)
                .always(function() {
                    au.State.reload(true);
                });
        },
        updateTo: function() {
            var update = this.updateFromState(au.State.get());
            var patches = Ext.create('Ext.data.Store', {
                fields: ['version', 'name'],
                data: Ext.Array.map(update.updates.patches || [], function(patch) {
                    return {
                        version: patch.toVersion,
                        name: patch.properties['plusworkflow-version'] + " #(" + patch.toVersion + ")"
                    };
                })
            });
            var projectKey = this.project;
            var me = this;
            var panel = Ext.create('Ext.Window', {
                modal: true,
                header: false,
                border: false,
                resizable: false,
                height: 'auto',
                layout: {
                    type: 'hbox'
                },
                bodyStyle: "padding-top: 5px;",
                items: [{
                    xtype: 'combo',
                    store: patches,
                    displayField: 'name',
                    valueField: 'version',
                    queryMode: 'local',
                    allowBlank: false
                }, {
                    xtype: 'button',
                    iconCls: 'dvnt-icon-check-symbol dvnt-green-icon',
                    handler: function() {
                        var window = this.up('window');
                        var combo = window.down('combo');
                        if (combo.isValid()) {
                            update = me.updateFromState(au.State.get());
                            update.state = 'APPLYING';
                            au.State.changed();
                            jQuery.post(auApp.basePath + '/updates/' + projectKey + '/apply?version=' + combo.getValue())
                                .always(function() {
                                    au.State.reload(true);
                                });
                            window.close();
                        }
                    }
                }, {
                    xtype: 'button',
                    iconCls: 'dvnt-icon-x-symbol dvnt-red-icon',
                    handler: function() {
                        this.up('window').close();
                    }
                }]
            });
            panel.show();
            panel.alignTo(this.downloadBtn);
        },
        checkNow: function() {
            var update = this.updateFromState(au.State.get());
            update.state = 'CHECKING';
            au.State.changed();
            jQuery.post(auApp.basePath + '/updates/' + this.project + '/check')
                .always(function() {
                    au.State.reload(true);
                });
        },
        stateChanged: function(state) {
            this.whenRendered(function() {
                var el = this.getEl();
                var element = this.updateFromState(state);

                if (element && element.currentVersion && element.currentVersion.includes("SNAPSHOT")) {
                    el.replaceCls(this.currentStateCls, "au-update-state-validated_error");
                    this.currentStateCls = "au-update-state-validated_error";
                    return;
                }

                var cls = "au-update-state-" + element.state.toLowerCase();
                el.replaceCls(this.currentStateCls, cls);
                this.currentStateCls = cls;
            });
        },

        titleText: function(update, state) {
            return Ext.String.format("{0} {1} - {2}",
                update.displayName,
                update.currentVersion,
                update.stateSummary);
        },
        currentVersionFieldValue: function(update, state, field) {
            return update.currentVersion ? update.currentVersion : "";
        },
        updateToNewestText: function(update, state, button) {
            return Ext.String.format(au.t("update.toVersion"), update.newestVersion);
        },
        updateToSpecificText: function(update, state, button) {
            return au.t("update.to");
        },
        showLoadingMask() {
            this._mask = this._mask || new Ext.LoadMask(this, {});
            this._mask.show();
            return this._mask;
        }
    });
});
