auApp.cmp.push(function(Ext) {

    // PROPS
    // target: string
    // patches: array[patch]
    // block: 
    // show:
    // text: 
    // icon: 
    // 
    // CONFIG
    // handler
    // iconRenderer
    return Ext.define("au.UpdateButton", {
        extend: Ext.button.Split,
        xtype: 'auUpdateButton',
        mixins: {
            stateAware: 'au.StateAware',
            action: 'au.ActionButtonMixin'
        },
        menuAlign: "tl-bl?",

        constructor: function(props) {
            function bind(prop, currentFn) {
                return function(state, me, current) {
                    if(currentFn) {
                        current(currentFn.call(this))
                    }
                    return prop(state);
                }
            }

            this.props = props;
            this.stateAware = {
                setVisible: function(state, me){
                    return props.patches(state).length > 0 && props.show(state);
                },
                setMenu: function(state, me) {
                    return {
                        "value": function(state, me) {
                            return props.patches(state)
                        },
                        "map": function(patches) {
                            if(patches.length > 0) {
                                return me.createPatchesMenu(patches, props.iconRenderer, function(grid, record, item, index) {
                                    me.invokeHandler(record.get("toVersion"));
                                    me.hideMenu();
                                });
                            }
                        }
                    };
                },
                setIconCls: function(state, me, current) {
                    if(me.isInProgress()) {
                        return me.iconCls;
                    }
                    return props.icon(state);
                },
                setText: bind(props.text),
                setInProgress: bind(props.block, this.isInProgress)
            };

            this.handler = function() {
                target = optionalProp(props.target, au.State.get());
                if(target){
                    this.invokeHandler(target);
                }
                else {
                    this.showMenu();
                }
            };
            this.arrowHandler = function() {
                this.showMenu();
            };
            this.callParent();
        },

        initComponent: function() {
            this.callParent();
            this.mixins.stateAware.init.call(this);
        },

        invokeHandler: function(version) {
            this.props.handler(this.lookupPatch(version));
        },

        lookupPatch: function(version) {
            var patches = this.props.patches(au.State.get());
            return Ext.Array.findBy(patches, function(patch) {
                return patch.toVersion == version;
            });
        },

        createPatchesMenu: function(patches, iconRenderer, handler) {
            return new Ext.menu.Menu({
                border: false,
                items: [
                    Ext.create('Ext.grid.Panel', {
                        store: Ext.create('Ext.data.Store', {
                            fields:['id', 'toVersion', 'validation'],
                            data:{'patches': patches},
                            proxy: {
                                type: 'memory',
                                reader: {
                                    type: 'json',
                                    root: 'patches'
                                }
                            }
                        }),
                        cls: "au-patches",
                        style: "border: 0; padding: 10px;",
                        border: false,
                        hideHeaders: true,
                        listeners: {
                            itemclick: handler
                        },
                        columns: [
                            { dataIndex: 'toVersion', flex: 1 },
                            { dataIndex: 'validation', renderer: function(validation, meta){
                                meta.style = 'text-align: center;';
                                return '<img src="' + Ext.BLANK_IMAGE_URL + '" class="' + iconRenderer(validation) + '" style="height: 16px; width:16px;"/>';
                            } }
                        ],
                        width: 400,
                        maxHeight: 600
                    })
                    ]
                });
        }
    });

    function optionalProp(prop, state) {
        return prop ? prop(state) : undefined;
    }

});
