auApp.cmp.push(function(Ext) {

    Ext.define('au.SystemUpdate', {
        extend: 'au.Update',
        xtype: 'auSystemUpdate',
        project: 'plusworkflow',
        collapsible: false,
        collapsed: false,
        tbar: {
            itemId: 'tbar',
            border: '1',
            hidden: true,
            items: [{
                xtype: 'tbtext',
                text: au.t("update.system.revision")
            }, {
                xtype: 'textfield',
                itemId: 'version-btn',
                allowBlank: false
            }, {
                xtype: 'button',
                text: au.t("update.system.save"),
                itemId: 'save-btn'
            }, {
                xtype: 'button',
                iconCls: 'dvnt-icon-x-circle',
                width: 36,
                itemId: 'cancel-btn'
            }]
        },

        constructor: function () {
            this.callParent([{
                items: [{
                    xtype: 'fieldcontainer',
                    fieldLabel: au.t("update.system.revision"),
                    layout: 'hbox',
                    width: 500,
                    items: [{
                        xtype: 'button',
                        iconCls: 'dvnt-icon-edit',
                        width: 36,
                        tooltip: au.t("update.system.revision.edit"),
                        handler: () => {
                            this.getDockedComponent('tbar').show();
                        }
                    }, {
                        xtype: "displayfield",
                        flex: 1,
                        stateAware: {
                            setValue: function (state, cmp) {
                                return cmp.updateFromState(state).currentVersion;
                            }
                        }
                    }]
                }]
            }]);
        },

        initComponent: function() {

            this.bbar.items.splice(2, 0, {
                xtype: 'form',
                border: false,
                url: auApp.basePath + '/updates/' + 'plusworkflow' + '/upload',
                items: [{
                    xtype: 'filefield',
                    name: 'file',
                    fieldLabel: au.t("update.system.upload"),
                    buttonText: " ",
                    ui: 'default-toolbar',
                    margin: 0,
                    listeners: {
                        change: function(btn) {
                            var mask = this.showLoadingMask();
                            btn.up("form").submit({
                                success: function(form) {
                                    mask.hide();
                                },
                                failure: function(form, action) {
                                    mask.hide();
                                    Ext.Msg.alert(au.t("error"), action.result.message || au.t("error.unknown"))
                                }
                            });
                        },
                        scope: this
                    }
                }],
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return (
                            update.state == 'ERROR' ||
                            update.state == 'UP_TO_DATE' ||
                            update.state == 'NO_UPDATES' ||
                            update.state == 'UPDATES_AVAILABLE' ||
                            update.state == 'INITIAL');
                    }
                }
            }, {
                xtype: 'button',
                text: au.t("update.system.force"),
                iconCls: 'dvnt-icon-exclamation-triangle dvnt-orange-icon',
                handler: this.forceApply,
                scope: this,
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'VALIDATED_ERROR';
                    }
                }
            }, {
                xtype: 'button',
                text: au.t("update.system.request"),
                iconCls: 'dvnt-icon-check-circle dvnt-green-icon',
                handler: this.forceApply,
                scope: this,
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'READY';
                    }
                }
            }, {
                xtype: 'button',
                text: au.t("update.system.cancel"),
                iconCls: 'dvnt-icon-x-octagon',
                handler: this.cancelUpdate,
                scope: this,
                stateAware: {
                    setText: function(state, cmp) {
                        const update = cmp.updateFromState(state);
                        const pendingPatches = update.pendingPatches || [];
                        const newestPendingPatch = pendingPatches[pendingPatches.length-1];

                        return Ext.String.format(au.t("update.system.cancel"),
                            newestPendingPatch?.properties["plusworkflow-version"],
                            newestPendingPatch?.toVersion
                        );
                    },
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.state == 'VALIDATED_ERROR' ||
                            update.state == 'READY' ||
                            update.state == 'POSTPONED_UPDATE' ||
                            update.state == 'POSTPONED_BACKUP';
                    }
                }
            }, {
                xtype: 'button',
                text: au.t("update.system.details"),
                iconCls: 'dvnt-icon-search',
                handler: this.showDetails,
                scope: this,
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.properties.validationResult &&
                            (update.state == 'VALIDATED_ERROR' || update.state == 'READY');
                    }
                }
            });
            this.bbar.items.push({
                xtype: 'button',
                iconCls: 'dvnt-icon-settings',
                handler: function() {
                    new au.SytemUpdateConfig({
                        update: this.updateFromState(au.State.get()),
                        updateFromState: this.updateFromState,
                        project: this.project
                    }).show();
                },
                scope: this,
                stateAware: {
                    setVisible: function(state, cmp) {
                        var update = cmp.updateFromState(state);
                        return update.properties.rollbacks &&
                            update.properties.rollbacks.length > 0 &&
                            (update.state == 'UPDATES_AVAILABLE' || update.state == 'UP_TO_DATE');
                    }
                }
            });
            this.callParent();
            this.mixins.stateAware.init.call(this);

            this.saveBtn = this.down('#save-btn');
            this.cancelBtn = this.down('#cancel-btn');
            this.versionField = this.down('#version-btn');

            this.saveBtn.on('click', this.saveVersion, this);
            this.cancelBtn.on('click', this.hideTbar, this);
        },
        saveVersion: function() {
            if (this.versionField.isValid()) {
                jQuery.post(auApp.basePath + '/configuration/version?version=' +
                        this.versionField.getValue())
                    .done(() => {
                        au.State.reload();
                        this.hideTbar();
                    });
            }
        },

        hideTbar() {
            this.getDockedComponent('tbar').hide();
        },

        titleText: function(update) {
            if (!update.currentVersion) {
                return Ext.String.format("{0} - {1}",
                    update.displayName,
                    au.t("update.system.notconfigured"));
            }
            if (update.state == 'POSTPONED_UPDATE' && update.properties.applyAfter) {
                var applyAfter = Ext.Date.parse(update.properties.applyAfter, "time");
                var now = new Date();
                if (applyAfter.getTime() > now.getTime()) {
                    return Ext.String.format(au.t("update.system.postponed"), Ext.Date.format(applyAfter, "Y-m-d H:i:s"));
                }
            }
            return Ext.String.format("{0} {1} - {2}",
                update.displayName,
                update.properties.systemVersion,
                update.stateSummary);
        },
        currentVersionFieldValue: function(update) {
            return update.properties.systemVersion + " (#" + this.callParent(arguments) + ")"
        },
        updateToNewestText: function(update) {
            if(Ext.isArray(update.updates.patches)) {
                var newest = update.updates.patches[update.updates.patches.length - 1];
                if (newest) {
                    return Ext.String.format(au.t("update.system.toVersion"), newest.properties["plusworkflow-version"], newest.toVersion);
                }
            }
        },
        updateToSpecificText: function(update) {
            return au.t("update.system.to");
        },

        forceApply: function() {
            new au.PickApplyDate({
                    update: this.updateFromState(au.State.get()),
                    project: this.project
                })
                .show();
        },
        cancelUpdate: function() {
            var update = this.updateFromState(au.State.get());
            update.state = 'CHECKING';
            au.State.changed();
            jQuery.post(auApp.basePath + '/updates/' + this.project + '/cancel')
                .always(function() {
                    au.State.reload(true);
                });
        },
        showDetails: function() {
            var update = this.updateFromState(au.State.get());
            new au.UpdateDetails({
                update: update
            }).show();
        }
    });

    Ext.define('au.SystemUpdates', {
        extend: 'Ext.Panel',
        mixins: {
            stateAware: 'au.StateAware'
        },
        xtype: 'auSystemUpdates',
        title: au.t("update.system"),
        stateAware: {
            setDisabled: function(state) {
                return !state.configured;
            }
        },
        items: [{
            xtype: 'auSystemUpdate'
        }],
        initComponent: function() {
            this.callParent();
            this.mixins.stateAware.init.call(this);
        }
    });

    Ext.define('au.PickApplyDate', {
        extend: 'Ext.window.Window',
        title: au.t("update.system.when"),
        modal: true,
        resizable: false,
        bodyPadding: 10,
        width: 450,
        initComponent: function() {
            this.items = [{
                xtype: "radio",
                name: "type",
                boxLabel: au.t("update.system.when.nextrun"),
                checked: true
            }, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                width: 400,
                items: [{
                    xtype: "radio",
                    name: "type",
                    boxLabel: 'Po',
                    listeners: {
                        change: this.dateRadioChange,
                        scope: this
                    }
                }, {
                    xtype: 'datefield',
                    name: 'date',
                    format: 'Y-m-d H:i:s',
                    disabled: true,
                    allowBlank: false,
                    width: 200,
                    value: new Date()
                }]
            }];
            this.buttons = [{
                text: au.t("update.system.apply"),
                handler: this.apply,
                scope: this
            }];
            this.callParent();

            this.dateField = this.down('datefield');
        },

        dateRadioChange: function(cmp, value) {
            this.dateField.setDisabled(!value);
        },

        apply: function() {
            if (!this.dateField.isDisabled() && !this.dateField.isValid()) {
                return;
            }

            this.update.state = 'APPLYING';
            au.State.changed();
            var when = "";
            if (!this.dateField.isDisabled()) {
                var when = this.dateField.getValue().toJSON();
            }
            var me = this;
            jQuery.post(auApp.basePath + '/updates/' + this.project + '/apply/confirm?when=' + when)
                .always(function() {
                    au.State.reload(true);
                    me.close();
                });
        }
    });

    Ext.define('au.SytemUpdateConfig', {
        extend: 'Ext.window.Window',
        title: au.t("updates.configuration"),
        modal: true,
        resizable: true,
        bodyStyle: 'background: white',
        layout: 'accordion',
        width: 650,
        height: 550,
        initComponent: function() {
            this.backupStore = Ext.create('Ext.data.Store', {
                fields: ['fileName', {
                    name: 'applied',
                    type: 'date',
                    dateFormat: 'time'
                }, 'from', 'to'],
                sorters: [{
                  property: "applied",
                  direction: "DESC"
                }],
                data: this.update.properties.rollbacks
            });
            this.items = [{
                xtype: 'grid',
                title: au.t("update.system.backups"),
                bodyStyle: 'background: white',
                store: this.backupStore,
                columns: [{
                    text: au.t("update.system.backup.name"),
                    dataIndex: 'fileName',
                    flex: 1
                }, {
                    text: au.t("update.system.backup.created"),
                    xtype: 'datecolumn',
                    format: 'Y-m-d H:i:s',
                    dataIndex: 'applied',
                    width: 120
                }, {
                    text: au.t("update.system.backup.from"),
                    dataIndex: 'from',
                    width: 50
                }, {
                    text: au.t("update.system.backup.to"),
                    dataIndex: 'to',
                    width: 50
                }],
                buttons: [{
                    text: au.t("update.system.backup.restore"),
                    iconCls: 'dvnt-icon-rotation-left dvnt-green-icon',
                    handler: this.restore,
                    scope: this
                }]
            }];
            this.buttons = [{
                text: au.t("update.system.backup.close"),
                handler: this.close,
                scope: this
            }];
            this.callParent();

            this.backups = this.down('grid');
        },

        restore: function() {
            var sm = this.backups.getSelectionModel();
            if (sm.hasSelection()) {
                var selected = sm.getSelection()[0];
                this.updateFromState(au.State.get()).state = 'APPLYING_BACKUP';
                au.State.changed();
                var me = this;
                jQuery.ajax({
                        method: 'POST',
                        url: auApp.basePath + '/updates/' + this.project + '/rollback',
                        data: JSON.stringify(selected.data),
                        contentType: "application/json",
                        dataType: 'json'
                    })
                    .always(function() {
                        au.State.reload(true);
                    });
                me.close();
            }
        }
    });
});
