auApp.cmp.push(function(Ext) {

    Ext.define('au.PluginUpdate', {
        extend: 'au.Update',
        xtype: 'auPluginUpdate',
        
        constructor: function(config) {
            var me = this,
                project = config.project;

            function projectSelector(fn) {
                return function(state) {
                    return fn(config.project)(state);
                }
            }

            function withSelected(selector, fn) {
                return function(state) {
                    return fn(projectSelector(selector)(state), state);
                }
            }

            this.project = project;
            this.callParent([{
                buttons: [{
                    xtype: "auUpdateButton",
                    patches: projectSelector(upgrades),
                    block: projectSelector(block),
                    show: projectSelector(show),
                    target: projectSelector(newest),
                    text: withSelected(newest, function(newest) {
                        return newest
                            ? Ext.String.format(au.t("update.toVersion"), newest)
                            : au.t("update.invalidAvailable");
                    }),
                    icon: withSelected(newest, function(newest) {
                        return newest ? "dvnt-icon-check-circle dvnt-green-icon" : "dvnt-icon-star dvnt-orange-icon"
                    }),
                    handler: Ext.bind(me.updatePlugin, me),
                    iconRenderer: iconRenderer
                }, {
                    xtype: 'auButton',
                    props: {
                        show: withSelected(changelog, changelog => changelog != null),
                        href: projectSelector(changelog)
                    },
                    hrefTarget: "_blank",
                    text: "Changelog",
                    iconCls: "dvnt-icon-list"
                },{
                    xtype: "auUpdateButton",
                    patches: projectSelector(downgrades),
                    block: projectSelector(block),
                    show: projectSelector(show),
                    text: function() {
                        return au.t("downgrade.toVersion");
                    },
                    icon: function() {
                        return "dvnt-icon-down-straight dvnt-green-icon"
                    },
                    handler: Ext.bind(me.updatePlugin, me),
                    iconRenderer: iconRenderer
                }]
            }]);
        },

        initComponent: function() {
            this.callParent();
        },

        updatePlugin: function(patch) {
            var me = this;
            matchValidation(patch.validation,
                function() { me.updateToVersion(patch.toVersion); },
                function() { 
                    au.PluginValidation.show(patch.validation, function() {
                        me.updateToVersion(patch.toVersion);
                    })
                 }
            )
        }
    });

    function update(project) {
        return function(state) {
            return state.updates[project];
        };
    }

    function newest(project) {
        return function(state) {
            return update(project)(state).updates.newestVersion
        }
    }

    function newestPatch(project) {
        return function(state) {
            return update(project)(state).updates.newest
        }
    }

    function upgrades(project) {
        return function(state) {
            return update(project)(state).updates.updates || []
        }
    }

    function downgrades(project) {
        return function(state) {
            return update(project)(state).updates.downgrades || []
        }
    }

    /**
     * Changelog of newest patch
     */
    function changelog(project) {
        return function(state) {
            return newestPatch(project)(state)?.properties["changelog"]
        }
    }

    function block(project) {
        return function(state) {
            var status = update(project)(state).state
            return status == 'DOWNLOADING' ||
            status == 'DOWNLOADED' ||
            status == 'VALIDATING' ||
            status == 'READY' ||
            status == 'APPLYING';
        }
    }

    function show(project) {
        return function(state) {
            var status = update(project)(state).state
            return status != 'ERROR' || status != 'INIT';
        }
    }

    function matchValidation(validation, valid, blocked, warning) {

        if(!Ext.isEmpty(validation.missing.mandatory)) {
            return blocked(validation);
        }
        else if(!Ext.isEmpty(validation.missing.optional) || !Ext.isEmpty(validation.provided.mandatory) || !Ext.isEmpty(validation.provided.optional)) {
            return (warning || blocked)(validation);
        }
        else {
            return valid(validation);
        }
    }

    function iconRenderer(validation) {
        return matchValidation(validation,
            function() { return "dvnt-icon-check-symbol dvnt-green-icon"; },
            function() { return "dvnt-icon-exclamation-circle dvnt-red-icon"; },
            function() { return "dvnt-icon-exclamation-triangle dvnt-orange-icon"; });
    }
});
