package com.suncode.autoupdate.plusworkflow.web;

import com.plusmpm.util.Authorization;
import com.suncode.autoupdate.plusworkflow.update.engine.Updates;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpSession;
import java.sql.SQLException;

@Controller
@RequiredArgsConstructor( onConstructor = @__( @Autowired ) )
public class SetupController
{
    private final Updates updates;

    @RequestMapping( "/setup" )
    public String setupView( HttpSession session )
        throws SQLException
    {
        String username = (String) session.getAttribute( "username" );
        int rights = Authorization.checkRight( "system.admin", username, false, false );

        if ( rights == Authorization.nFULL )
        {
            updates.checkAll();
            return "setup";
        }
        else
        {
            throw new SecurityException( "No permission" );
        }
    }
}
