package com.suncode.autoupdate.plusworkflow.util;

import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Predicate;

@Slf4j
@UtilityClass
public class Exceptions {

    public static void safe(Runnable runnable) {
        safe(runnable, e -> true);
    }

    @SneakyThrows
    public static void safe(ThrowingRunnable runnable, Predicate<Throwable> ignoreCause) {
        safe( (Runnable) runnable, ignoreCause );
    }

    @SneakyThrows
    public static void safe(Runnable runnable, Predicate<Throwable> ignoreCause) {
        try {
            runnable.run();
        } catch (Exception e) {
            if(ignoreCause.test(e)) {
                log.error("Ignored failure", e);
            }
            else {
                throw e;
            }
        }
    }

    public interface ThrowingRunnable
        extends Runnable {
        @SneakyThrows
        default void run() {
            runSafe();
        }

        void runSafe() throws Exception;

        static Runnable throwing( ThrowingRunnable runnable) {
            return runnable;
        }
    }
}
