package com.suncode.autoupdate.plusworkflow.update.system;

import java.io.InputStream;

import javax.servlet.ServletContext;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

import com.suncode.autoupdate.tomcat.Hook;
import com.suncode.plugin.framework.Plugin;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
@RequiredArgsConstructor( onConstructor = @__( @Autowired ) )
public class TomcatHook
{
    private static String HOOK_JAR = "autoupdate-tomcat-hook.jar";

    private final Plugin plugin;
    private final ServletContext servletContext;

    public boolean install()
    {
        if ( installed() )
        {
            return true;
        }

        try
        {
            Resource resource = plugin.getResource( HOOK_JAR );
            try (InputStream inputStream = resource.getInputStream())
            {
                Hook.get().registerHook( servletContext, inputStream );
            }
        }
        catch ( Throwable e )
        {
            log.error( "Error installing tomcat hook", e );
        }
        return installed();
    }

    public boolean installed()
    {
        return Hook.get().isHookRegisterd( servletContext );
    }
}
