package com.suncode.autoupdate.plusworkflow.update.system;

import com.suncode.autoupdate.plusworkflow.update.Patches;
import com.suncode.autoupdate.server.client.api.Patch;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Value;
import lombok.experimental.FieldDefaults;
import lombok.experimental.NonFinal;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;

import static com.suncode.pwfl.util.Streams.unsupported;
import static lombok.AccessLevel.PRIVATE;

@Value
class InOrderPatches implements Patches {
    String newest;
    List<Patch> patches;

    @Override
    public Optional<Patch> get(UUID patchId) {
        return patches.stream()
                .filter(patch -> patch.getId().equals(patchId))
                .findFirst();
    }

    @Override
    public boolean hasAny() {
        return !patches.isEmpty();
    }

    @Override
    public Optional<String> getNewestVersion() {
        return Optional.ofNullable(newest);
    }

    @Override
    public List<Patch> neededFor(String version) {
        return patches.stream()
                .reduce(new Reducer(version), Reducer::reduce, unsupported())
                .getPatches();
    }

    @RequiredArgsConstructor
    @FieldDefaults(level = PRIVATE, makeFinal = true)
    private class Reducer {
        String target;

        @NonFinal
        boolean found;
        @Getter
        List<Patch> patches = new ArrayList<>();

        Reducer reduce(Patch patch) {
            if (!found) {
                patches.add(patch);
                if (patch.getToVersion().equals(target)) {
                    found = true;
                }
            }
            return this;
        }
    }
}