package com.suncode.autoupdate.plusworkflow.update.support;

import static com.suncode.autoupdate.plusworkflow.update.UpdateState.ERROR;

import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.suncode.autoupdate.plusworkflow.update.UpdateEvent;
import com.suncode.autoupdate.plusworkflow.update.UpdateState;
import com.suncode.autoupdate.plusworkflow.util.Consumer;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@RequiredArgsConstructor
public abstract class AbstractAction
    implements Action1<Transition<UpdateState, UpdateEvent>>
{
    private final Consumer<Throwable> onError;

    @Override
    public final void doIt( Transition<UpdateState, UpdateEvent> transition )
    {
        try
        {
            run( transition.getSource(), transition.getDestination(), transition.getTrigger() );
        }
        catch ( Throwable t )
        {
            log.error( "Transition {}->{} (with {}) failed with error on [{}]", transition.getSource(),
                       transition.getDestination(),
                       transition.getTrigger(),
                       getClass().getName(),
                       t );
            if ( transition.getDestination() != ERROR )
            {
                onError.accept( t );
            }
        }
    }

    protected abstract void run( UpdateState from, UpdateState to, UpdateEvent trigger );
}
