package com.suncode.autoupdate.plusworkflow.update.download;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.Patch;
import com.suncode.autoupdate.server.client.api.Patches;
import com.suncode.plugin.framework.PluginStore;
import com.suncode.plugin.framework.PluginStoreResource;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;

@Slf4j
@Component
public class Downloader
{
    @Autowired
    private PluginStore store;

    @SneakyThrows
    public void upload(PatchMeta patch,  InputStream stream) {
        String path = patchPath( patch );
        store.store(path, stream, true);
        log.info( "Patch {} has been uploaded", patch );
    }

    @Async
    @SneakyThrows
    public Future<PluginStoreResource> download( Patch patch, UpdateServerClient client )
    {
        String path = patchPath( patch );
        PluginStoreResource downloaded = store.read( path );
        if ( downloaded == null )
        {
            log.info( "Downloading patch {} from server and storing in {}", patch, path );
            downloadFromServer( client, path, patch );
            downloaded = store.read( path );
        }
        log.info( "Patch {} has been downloaded", patch );
        return new AsyncResult<PluginStoreResource>( downloaded );
    }

    @SneakyThrows
    private void downloadFromServer( UpdateServerClient client, final String path, final Patch patch )
    {
        try
        {
            client.patches().download( patch, new Patches.PatchStreamConsumer() {
                @Override
                public void accept( InputStream inputStream )
                    throws IOException
                {
                    log.info( "Storing patch {} in plugin store under {}", patch, path );
                    store.store( path, inputStream );
                    log.info( "Patch {} stored under {}", patch, path );
                }
            } );
        }
        catch ( IOException e )
        {
            store.delete( path );
            throw e;
        }
    }

    private String patchPath( Patch patch )
    {
        return "downloads/" + patch.getId();
    }

    private String patchPath( PatchMeta patch )
    {
        return "downloads/" + patch.getPatchId();
    }
}
