package com.suncode.autoupdate.plusworkflow.update.download;

import com.suncode.autoupdate.plusworkflow.update.download.Download.DownloadBuilder;
import com.suncode.autoupdate.server.client.UpdateServerClient;
import com.suncode.autoupdate.server.client.api.Patch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class DownloadQueue
{
    @Autowired
    private Downloader downloader;

    public Download schedule(List<Patch> patches, UpdateServerClient client )
    {
        DownloadBuilder downloads = Download.builder();
        for ( Patch patch : patches )
        {
            log.info( "Scheduling download for patch {}", patch);
            downloads.task( patch, downloader.download( patch, client ) );
        }
        return downloads.build();
    }
}
