package com.suncode.autoupdate.plusworkflow.update;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.experimental.Wither;

@Value
@Builder
@AllArgsConstructor
@Wither
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Updates<T>
{
    T updates;
    List<PendingPatch> pendingPatches;

    String name;
    String displayName;
    String channel;
    String currentVersion;
    UpdateState state;
    String stateSummary;
    String newestVersion;
    Date lastCheck;
    Map<String, Object> properties;
}