package com.suncode.autoupdate.plusworkflow.update;

import com.google.common.collect.ImmutableMap;
import com.suncode.autoupdate.server.client.api.Patch;
import lombok.NonNull;
import lombok.Value;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

@Value
public class PendingPatch {
    @NonNull
    UUID id;
    @NonNull
    String fromVersion;
    @NonNull
    String toVersion;
    @NonNull
    Map<String, String> properties;

    public static PendingPatch from(Patch patch) {
        return new PendingPatch(patch.getId(), patch.getFromVersion(), patch.getToVersion(), ImmutableMap.copyOf(patch.getProperties()));
    }

    public static List<PendingPatch> map( List<Patch> patches )
    {
        return patches.stream().map( PendingPatch::from ).collect( Collectors.toList());
    }
}
