package com.suncode.autoupdate.plusworkflow.update;

import com.suncode.autoupdate.server.client.api.Patch;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

import static java.util.Collections.emptyList;
import static java.util.Optional.empty;

public interface Patches {
    Optional<Patch> get(UUID patchId);

    boolean hasAny();

    Optional<String> getNewestVersion();

    List<Patch> neededFor(String version);

    class NoPatches implements Patches {

        @Override
        public Optional<Patch> get(UUID patchId) {
            return Optional.empty();
        }

        @Override
        public boolean hasAny() {
            return false;
        }

        @Override
        public Optional<String> getNewestVersion() {
            return empty();
        }

        @Override
        public List<Patch> neededFor(String version) {
            return emptyList();
        }
    }
}
