package com.suncode.autoupdate.plusworkflow.config;

import com.suncode.autoupdate.plusworkflow.update.engine.UpdateEngine;
import com.suncode.autoupdate.server.client.Identity;
import com.suncode.autoupdate.server.client.IdentityProvider;
import com.suncode.plugin.framework.service.Provides;
import lombok.RequiredArgsConstructor;
import lombok.experimental.FieldDefaults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static lombok.AccessLevel.PRIVATE;

@Component
@Provides(IdentityProvider.class)
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@FieldDefaults(level = PRIVATE, makeFinal = true)
public class EngineIdentityProvider implements IdentityProvider {
    UpdateEngine updateEngine;

    @Override
    public Identity get() {
        if (!updateEngine.isConfigured()) {
            throw new IllegalStateException("Updates not configured properly");
        }
        return new Identity(
                updateEngine.getConfig().getServerUrl(),
                updateEngine.getConfig().getApiToken(),
                updateEngine.getConfig().getEnvironment()
        );
    }
}
